
--填充任务编号 
UPDATE t_project_task
SET task_code = 'PT_' + RIGHT('000000' + CAST(object_id AS VARCHAR), 6)
WHERE task_code IS NULL 
   OR task_code = ''
   OR task_code LIKE '[ ]%' 
   OR LTRIM(RTRIM(task_code)) = '';

--填充任务编号 
UPDATE t_project_task_template
SET task_code = 'TPL_' + RIGHT('000000' + CAST(object_id AS VARCHAR), 6)
WHERE task_code IS NULL 
   OR task_code = ''
   OR task_code LIKE '[ ]%' 
   OR LTRIM(RTRIM(task_code)) = '';   

--删除t_delivery_location_to_owner表中rolea_object_id=0的记录
DELETE FROM t_delivery_location_to_owner
WHERE rolea_object_id = 0;

--转换sort_code至sort_order
UPDATE t_project_task 
SET sort_order = (
    CASE 
        WHEN sort_code IS NOT NULL 
        AND sort_order = 0
        AND sort_code LIKE '%____.____%' 
        AND sort_code NOT LIKE '%[^0-9.]%'
        AND LEN(sort_code) - LEN(REPLACE(sort_code, '.', '')) = 3
        THEN (
            CAST(
                RIGHT(sort_code, 4) AS INT
            ) * 10
        )
        ELSE sort_order 
    END
);

--修复计划时间中时间部分
UPDATE t_project SET planned_start_datetime = CAST(CAST(planned_start_datetime AS DATE) AS DATETIME);
UPDATE t_project SET planned_end_datetime = CAST(CAST(planned_end_datetime AS DATE) AS DATETIME);
UPDATE t_project_task SET planned_start_datetime = CAST(CAST(planned_start_datetime AS DATE) AS DATETIME);
UPDATE t_project_task SET planned_end_datetime = CAST(CAST(planned_end_datetime AS DATE) AS DATETIME);