
--填充任务编号 
UPDATE t_project_task
SET task_code = 'PT_' || LPAD(object_id::text, 6, '0')
WHERE task_code IS NULL 
   OR task_code = ''
   OR task_code ~ '^[[:space:]]*$';

--填充模板任务编号 
UPDATE t_project_task_template
SET task_code = 'TPL_' || LPAD(object_id::text, 6, '0')
WHERE task_code IS NULL 
   OR task_code = ''
   OR task_code ~ '^[[:space:]]*$';   

--删除t_delivery_location_to_owner表中rolea_object_id=0的记录
DELETE FROM t_delivery_location_to_owner
WHERE rolea_object_id = 0;

--转换sort_code至sort_order
UPDATE t_project_task 
SET sort_order = (
    CASE 
        WHEN sort_code IS NOT NULL 
        AND sort_order = 0
        AND sort_code ~ '^(\d{4}\.)*\d{4}$' 
        THEN (
            CAST(
                RIGHT(sort_code, 4) AS INTEGER
            ) * 10
        )
        ELSE sort_order 
    END
);

--修复计划时间中时间部分
UPDATE t_project SET planned_start_datetime = DATE_TRUNC('day', planned_start_datetime);
UPDATE t_project SET planned_end_datetime = DATE_TRUNC('day', planned_end_datetime);
UPDATE t_project_task SET planned_start_datetime = DATE_TRUNC('day', planned_start_datetime);
UPDATE t_project_task SET planned_end_datetime = DATE_TRUNC('day', planned_end_datetime);