CREATE TABLE U_VAULT(
    SOURCE_CLASS_ID integer NOT NULL, 
    SOURCE_OBJECT_ID integer NOT NULL,
    SOURCE_NAME nvarchar(256) NULL,
    VAULT nvarchar(256) NULL,
PRIMARY KEY(SOURCE_CLASS_ID,SOURCE_OBJECT_ID)
) ON [PRIMARY]

GO

CREATE TABLE U_VAULT_PATH(
    SOURCE_CLASS_ID integer NOT NULL, 
    SOURCE_OBJECT_ID integer NOT NULL,
    SOURCE_PATH nvarchar(256) NOT NULL,
    VAULT nvarchar(256) NULL,
    VIRTUAL_DISK nvarchar(256) NULL,
    PATH nvarchar(256) NULL,
PRIMARY KEY(SOURCE_CLASS_ID,SOURCE_OBJECT_ID,SOURCE_PATH)
) ON [PRIMARY]

GO

CREATE TABLE U_CLASS_MAPPING(
    SOURCE_CLASS_ID integer NOT NULL, 
    INTERNAL_NAME nvarchar(56) NULL,
PRIMARY KEY(SOURCE_CLASS_ID)
) ON [PRIMARY]

GO
CREATE TABLE U_WORKFLOW_META_TEMPLATE(
    SOURCE_CLASS_ID integer NOT NULL, 
    SOURCE_OBJECT_ID integer NOT NULL,
    workflow_meta_template_id nvarchar(64) NULL,
    workflow_meta_template_classification nvarchar(64) NULL,
    workflow_meta_template_use_type nvarchar(64) NULL,
    UPGRADE_SUCCESS_FLAG int DEFAULT (0) NOT NULL,
    IMPORT_SUCCESS_FLAG int DEFAULT (0) NOT NULL,
PRIMARY KEY(SOURCE_CLASS_ID,SOURCE_OBJECT_ID)
)ON [PRIMARY]

GO
CREATE TABLE U_WORKFLOW_META_PROCESS(
    SOURCE_CLASS_ID integer NOT NULL,     
    SOURCE_OBJECT_ID integer NOT NULL,
    SOURCE_WORKFLOW_META_PROCESS_ID nvarchar(64) NOT NULL,
    WORKFLOW_META_PROCESS_ID nvarchar(64) NULL,
    workflow_meta_template_id nvarchar(64) NULL,
    UPGRADE_SUCCESS_FLAG int DEFAULT (0) NOT NULL,
    IMPORT_SUCCESS_FLAG int DEFAULT (0) NOT NULL, 
PRIMARY KEY(SOURCE_CLASS_ID,SOURCE_OBJECT_ID,SOURCE_WORKFLOW_META_PROCESS_ID)
)ON [PRIMARY]

GO
CREATE TABLE U_WORKFLOW_META_ACTIVITY(
    SOURCE_CLASS_ID integer NOT NULL, 
    SOURCE_OBJECT_ID integer NOT NULL,
    SOURCE_WORKFLOW_META_PROCESS_ID nvarchar(64) NOT NULL,
    SOURCE_WORKFLOW_META_ACTIVITY_ID nvarchar(64) NOT NULL,
    WORKFLOW_META_TEMPLATE_ID nvarchar(64) NULL,
    WORKFLOW_META_PROCESS_ID nvarchar(64) NULL,
    WORKFLOW_META_ACTIVITY_ID nvarchar(64) NULL,
    WORKFLOW_META_TEMPLATE_NAME nvarchar(64) NULL,
    WORKFLOW_META_TEMPLATE_FILE_NAME nvarchar(64) NULL,
    WORKFLOW_META_PROCESS_NAME nvarchar(64) NULL,
    WORKFLOW_META_ACTIVITY_NAME nvarchar(64) NULL,
    UPGRADE_SUCCESS_FLAG int DEFAULT (0) NOT NULL,
    IMPORT_SUCCESS_FLAG int DEFAULT (0) NOT NULL,
PRIMARY KEY(SOURCE_CLASS_ID,SOURCE_OBJECT_ID,SOURCE_WORKFLOW_META_PROCESS_ID,SOURCE_WORKFLOW_META_ACTIVITY_ID)
)ON [PRIMARY]

GO

CREATE TABLE U_WORKFLOW_META_TRANSITION(
    SOURCE_CLASS_ID integer NOT NULL, 
    SOURCE_OBJECT_ID integer NOT NULL,
    SOURCE_WORKFLOW_META_PROCESS_ID nvarchar(64) NOT NULL,
    SOURCE_WORKFLOW_META_TRANSITION_ID nvarchar(64) NOT NULL,
    WORKFLOW_META_TEMPLATE_ID nvarchar(64) NULL,
    WORKFLOW_META_PROCESS_ID nvarchar(64) NULL,
    WORKFLOW_META_TRANSITION_ID nvarchar(64) NULL,
    UPGRADE_SUCCESS_FLAG int DEFAULT (0) NOT NULL,
    IMPORT_SUCCESS_FLAG int DEFAULT (0) NOT NULL,
PRIMARY KEY(SOURCE_CLASS_ID,SOURCE_OBJECT_ID,SOURCE_WORKFLOW_META_PROCESS_ID,SOURCE_WORKFLOW_META_TRANSITION_ID)
)ON [PRIMARY]

GO

CREATE TABLE U_CLASSEXPINDEXSET(
    SOURCE_SECU_CLASS_ID int NOT NULL, 
    SOURCE_PROPERTY_FILTER_INDEX int NOT NULL,
    INTERNAL_NAME nvarchar(56) NOT NULL,
    OBJECT_ID bigint NOT NULL,
    RBAC_META_INTERNAL_NAME nvarchar(56) NOT NULL,
PRIMARY KEY(OBJECT_ID)
)ON [PRIMARY]

GO
CREATE TABLE U_WFProcessInst(
    SOURCE_OBJECT_ID int NOT NULL, 
    SOURCE_CLASS_ID int NOT NULL, 
    INTERNAL_NAME nvarchar(56) NOT NULL,
    OBJECT_ID bigint NOT NULL,
    WORKFLOW_META_PROCESS_ID nvarchar(64) NULL, 
    WORKFLOW_META_TEMPLATE_ID nvarchar(64)  NULL, 
    WORKFLOW_META_TEMPLATE_INSTANCE_ID nvarchar(64)  NULL, 
    WORKFLOW_META_TEMPLATE_CLASSIFICATION nvarchar(64) NULL, 
    WORKFLOW_META_TEMPLATE_USE_TYPE nvarchar(64)  NULL, 
    PRIMARY KEY(SOURCE_OBJECT_ID)
)ON [PRIMARY]

GO
CREATE INDEX IDX_U_WFProcessInst ON U_WFProcessInst(SOURCE_OBJECT_ID, SOURCE_CLASS_ID) ON [PRIMARY]

GO
CREATE TABLE U_WFActivityInst(
    SOURCE_OBJECT_ID int NOT NULL, 
    SOURCE_CLASS_ID int NOT NULL, 
    INTERNAL_NAME nvarchar(56) NOT NULL,
    OBJECT_ID bigint NOT NULL,
    WORKFLOW_META_PROCESS_ID nvarchar(64) NULL,
    WORKFLOW_META_ACTIVITY_ID nvarchar(64)  NULL, 
    WORKFLOW_META_TEMPLATE_ID nvarchar(64)  NULL, 
PRIMARY KEY(SOURCE_OBJECT_ID)
)ON [PRIMARY]

GO
CREATE INDEX IDX_U_WFActivityInst ON U_WFActivityInst(SOURCE_OBJECT_ID, SOURCE_CLASS_ID) ON [PRIMARY]


GO
CREATE TABLE U_WFWorkitem(
    SOURCE_OBJECT_ID int NOT NULL, 
    SOURCE_CLASS_ID int NOT NULL, 
    INTERNAL_NAME nvarchar(56) NOT NULL,
    OBJECT_ID bigint NOT NULL,
    WORKFLOW_META_TEMPLATE_ID nvarchar(64)  NULL, 
    WORKFLOW_META_TASK_CLASSIFICATION nvarchar(64) NULL, 
    WORKFLOW_META_TASK_USE_TYPE nvarchar(64)  NULL, 
PRIMARY KEY(SOURCE_OBJECT_ID)
) ON [PRIMARY]
GO
CREATE INDEX IDX_U_WFWorkitem ON U_WFWorkitem(SOURCE_OBJECT_ID, SOURCE_CLASS_ID) ON [PRIMARY]

GO
CREATE TABLE  U_WfTransitionInst(
    SOURCE_OBJECT_ID int NOT NULL, 
    SOURCE_CLASS_ID int NOT NULL, 
    INTERNAL_NAME nvarchar(56) NOT NULL,
    OBJECT_ID bigint NOT NULL,
    WORKFLOW_META_TRANSITION_ID nvarchar(64)  NULL, 
    WORKFLOW_FROM_META_ACTIVITY_ID nvarchar(64) NULL, 
    WORKFLOW_TO_META_ACTIVITY_ID nvarchar(64)  NULL, 
PRIMARY KEY(SOURCE_OBJECT_ID)
) ON [PRIMARY]
GO
CREATE INDEX IDX_U_WfTransitionInst ON U_WfTransitionInst(SOURCE_OBJECT_ID, SOURCE_CLASS_ID) ON [PRIMARY]

GO
CREATE TABLE  U_WfParticipantInst(
    SOURCE_OBJECT_ID int NOT NULL, 
    SOURCE_CLASS_ID int NOT NULL, 
    INTERNAL_NAME nvarchar(56) NOT NULL,
    OBJECT_ID bigint NOT NULL,
    WORKFLOW_META_PROCESS_ID nvarchar(64)  NULL, 
    WORKFLOW_META_ACTIVITY_ID nvarchar(64) NULL, 
PRIMARY KEY(SOURCE_OBJECT_ID)
) ON [PRIMARY]
GO
CREATE INDEX IDX_U_WfParticipantInst ON U_WfParticipantInst(SOURCE_OBJECT_ID, SOURCE_CLASS_ID) ON [PRIMARY]
GO
CREATE TABLE U_WFDynamicPerform(
    SOURCE_OBJECT_ID int NOT NULL, 
    SOURCE_CLASS_ID int NOT NULL, 
    INTERNAL_NAME nvarchar(56) NOT NULL,
    OBJECT_ID bigint NOT NULL,
    WORKFLOW_META_ACTIVITY_ID nvarchar(64)  NULL, 
    WORKFLOW_META_PROCESS_ID nvarchar(64) NULL,
PRIMARY KEY(SOURCE_OBJECT_ID)
)ON [PRIMARY]

GO
CREATE INDEX IDX_U_WFDynamicPerform ON U_WFDynamicPerform(SOURCE_OBJECT_ID, SOURCE_CLASS_ID) ON [PRIMARY]

GO
CREATE TABLE U_DelegateData(
    SOURCE_OBJECT_ID int NOT NULL, 
    SOURCE_CLASS_ID int NOT NULL, 
    INTERNAL_NAME nvarchar(56) NOT NULL,
    OBJECT_ID bigint NOT NULL,
    WORKFLOW_META_TEMPLATE_IDS nvarchar(max)  NULL, 
primary key(SOURCE_OBJECT_ID)
)ON [PRIMARY]
GO
CREATE INDEX IDX_U_DelegateData ON U_DelegateData(SOURCE_OBJECT_ID, SOURCE_CLASS_ID) ON [PRIMARY]

GO
CREATE TABLE  U_OpinionToTargetLink(
    SOURCE_OBJECT_ID int NOT NULL, 
    SOURCE_CLASS_ID int NOT NULL, 
    INTERNAL_NAME nvarchar(56) NOT NULL,
    OBJECT_ID bigint NOT NULL,
    ROLEB_OBJECT_ID bigint  NULL, 
    ROLEB_INTERNAL_NAME nvarchar(56)  NULL,
PRIMARY KEY(SOURCE_OBJECT_ID)
)ON [PRIMARY]
GO
CREATE INDEX IDX_U_OpinionToTargetLink ON U_OpinionToTargetLink(SOURCE_OBJECT_ID, SOURCE_CLASS_ID) ON [PRIMARY]


GO
CREATE TABLE U_WFWorkitemReviewObjectLink(
    SOURCE_OBJECT_ID int NOT NULL, 
    SOURCE_CLASS_ID int NOT NULL,
    INTERNAL_NAME nvarchar(56) NOT NULL,
    OBJECT_ID bigint NOT NULL,
    ROLEA_OBJECT_ID bigint  NULL, 
    ROLEA_INTERNAL_NAME nvarchar(56)  NULL,
    ROLEB_OBJECT_ID bigint  NULL, 
    ROLEB_INTERNAL_NAME nvarchar(56)  NULL,
PRIMARY KEY(SOURCE_OBJECT_ID)
)ON [PRIMARY]
GO
CREATE INDEX IDX_U_WFWorkitemReviewObjectLink ON U_WFWorkitemReviewObjectLink(SOURCE_OBJECT_ID, SOURCE_CLASS_ID) ON [PRIMARY]
GO

GO

CREATE TABLE u_ObjPersonRoleSecuSet(
    SOURCE_CLASS_ID integer NOT NULL, 
    SOURCE_OBJECT_ID integer NOT NULL,
    INTERNAL_NAME nvarchar(56) NULL,
    OBJECT_ID bigint NULL,
    SOURCE_RBAC_CLASS_ID integer NOT NULL,
    SOURCE_RBAC_OBJECT_ID integer NOT NULL,
    RBAC_OBJECT_ID bigint NULL,
    RBAC_META_INTERNAL_NAME nvarchar(56) NULL,
    SOURCE_ACTOR_CLASS_ID integer NULL,
    SOURCE_ACTOR_OBJECT_ID integer NULL,
    ACTOR_INTERNAL_NAME nvarchar(56) NULL,
    ACTOR_OBJECT_ID bigint NULL,
    SOURCE_ROLE_CLASS_ID integer NULL,
    SOURCE_ROLE_OBJECT_ID integer NULL,
    ROLE_INTERNAL_NAME nvarchar(56) NULL,
    ROLE_OBJECT_ID bigint NULL,
PRIMARY KEY(SOURCE_CLASS_ID,SOURCE_OBJECT_ID)
)ON [PRIMARY]

GO

CREATE TABLE u_rbac_object_team(
    OBJECT_ID bigint NOT NULL, 
    INTERNAL_NAME nvarchar(56) NOT NULL,
    PARENT_OBJECT_ID bigint NULL,
    PARENT_INTERNAL_NAME nvarchar(56) NULL,
    TEAM_OWNER_OBJECT_ID bigint NULL,
    TEAM_OWNER_INTERNAL_NAME nvarchar(56) NULL,
    TEAM_OBJECT_ID bigint NULL,
    TEAM_INTERNAL_NAME nvarchar(56) NULL,
PRIMARY KEY(OBJECT_ID,INTERNAL_NAME)
)ON [PRIMARY]

GO

CREATE TABLE u_nonactor_object(
    SOURCE_RBAC_CLASS_ID integer NOT NULL,
    SOURCE_RBAC_OBJECT_ID integer NOT NULL,
    RBAC_OBJECT_ID bigint NULL,
    RBAC_META_INTERNAL_NAME nvarchar(56) NULL,
    TEAM_OBJECT_ID bigint NULL,
    TEAM_INTERNAL_NAME nvarchar(56) NULL,
    TEAM_OWNER_OBJECT_ID bigint NULL,
    TEAM_OWNER_INTERNAL_NAME nvarchar(56) NULL,
    NONACTOR_ROLE_INTERNAL_NAME nvarchar(56) NULL,
    NONACTOR_ROLE_OBJECT_ID bigint NULL,
PRIMARY KEY(SOURCE_RBAC_CLASS_ID,SOURCE_RBAC_OBJECT_ID)
)ON [PRIMARY]

GO

ALTER TABLE u_nonactor_object ADD TEAM_OBJECT_ID bigint NULL
GO

ALTER TABLE u_nonactor_object ADD TEAM_INTERNAL_NAME nvarchar(56) NULL
GO

ALTER TABLE u_nonactor_object ADD TEAM_OWNER_OBJECT_ID bigint NULL
GO

ALTER TABLE u_nonactor_object ADD TEAM_OWNER_INTERNAL_NAME nvarchar(56) NULL
GO


CREATE TABLE u_upgrade_info(
    NAME nvarchar(256) NOT NULL,
PRIMARY KEY(NAME)
)ON [PRIMARY]

GO

CREATE TABLE U_DocumentExternRef(
	SOURCE_CLASS_ID int NOT NULL,
	SOURCE_OBJECT_ID int NOT NULL,
	SOURCE_ROLEA_CLASS_ID int NOT NULL,
	SOURCE_ROLEA_ID int NOT NULL,
	SOURCE_ROLEB_CLASS_ID int NOT NULL,
	SOURCE_ROLEB_ID int NOT NULL,
	INTERNAL_NAME nvarchar(56) NOT NULL,
	OBJECT_ID bigint NOT NULL,
	ROLEA_INTERNAL_NAME nvarchar(56) NOT NULL,
	ROLEA_OBJECT_ID bigint NOT NULL,
    ROLEB_INTERNAL_NAME nvarchar(56) NOT NULL,
	ROLEB_OBJECT_ID bigint NOT NULL,
	PRIMARY KEY(SOURCE_CLASS_ID,SOURCE_OBJECT_ID)
)ON [PRIMARY]

GO

CREATE TABLE UH_DocumentExternRef(
	SOURCE_CLASS_ID int NOT NULL,
	SOURCE_OBJECT_ID int NOT NULL,
    SOURCE_SNAPSHOT_OBJECT_ID int NOT NULL,
    SOURCE_SNAPSHOT_CLASS_ID int NOT NULL,
	SOURCE_ROLEA_CLASS_ID int NOT NULL,
	SOURCE_ROLEA_ID int NOT NULL,
	SOURCE_ROLEB_CLASS_ID int NOT NULL,
	SOURCE_ROLEB_ID int NOT NULL,
	INTERNAL_NAME nvarchar(56) NOT NULL,
	OBJECT_ID bigint NOT NULL,
	ROLEA_INTERNAL_NAME nvarchar(56) NOT NULL,
	ROLEA_OBJECT_ID bigint NOT NULL,
    ROLEB_INTERNAL_NAME nvarchar(56) NOT NULL,
	ROLEB_OBJECT_ID bigint NOT NULL,
    SNAPSHOT_OBJECT_ID bigint NOT NULL,
	PRIMARY KEY(SOURCE_CLASS_ID,SOURCE_OBJECT_ID,SOURCE_SNAPSHOT_OBJECT_ID,SOURCE_SNAPSHOT_CLASS_ID)
)ON [PRIMARY]

GO

CREATE TABLE U_SIGNATURELOCATIONCFG(
    SOURCE_CLASS_ID int NOT NULL, 
    SOURCE_OBJECT_ID int NOT NULL,
    INTERNAL_NAME nvarchar(56) NOT NULL,
    OBJECT_ID bigint NOT NULL,
    WORKFLOW_META_TEMPLATE_ID nvarchar(64) NULL,
    WORKFLOW_META_TEMPLATE_NAME nvarchar(128) NULL,
    WORKFLOW_META_ACTIVITY_ID nvarchar(64) NULL,
    WORKFLOW_META_ACTIVITY_NAME nvarchar(128) NULL,
    FROM_HISTORY_FLAG bit DEFAULT (0) NULL,
PRIMARY KEY(OBJECT_ID)
)ON [PRIMARY]

GO

CREATE INDEX IDX_U_SIGNATURELOCATIONCFG ON U_SIGNATURELOCATIONCFG(SOURCE_OBJECT_ID, SOURCE_CLASS_ID)

GO

CREATE TABLE U_SIGNATURE(
    SOURCE_CLASS_ID int NOT NULL, 
    SOURCE_OBJECT_ID int NOT NULL,
    INTERNAL_NAME nvarchar(56) NOT NULL,
    OBJECT_ID bigint NOT NULL,
    WORKFLOW_META_TEMPLATE_ID nvarchar(64) NULL,
    WORKFLOW_META_TEMPLATE_NAME nvarchar(128) NULL,
    WORKFLOW_META_ACTIVITY_ID nvarchar(64) NULL,
    WORKFLOW_META_ACTIVITY_NAME nvarchar(128) NULL,
    FROM_HISTORY_FLAG bit DEFAULT (0) NULL,
PRIMARY KEY(SOURCE_OBJECT_ID, SOURCE_CLASS_ID)
)ON [PRIMARY]

Go

CREATE TABLE U_DOCUMENTSIGNATURE(
	SOURCE_CLASS_ID int NOT NULL,
	SOURCE_OBJECT_ID int NOT NULL,
	SOURCE_ROLEA_CLASS_ID int NOT NULL,
	SOURCE_ROLEA_ID int NOT NULL,
	SOURCE_ROLEB_CLASS_ID int NOT NULL,
	SOURCE_ROLEB_ID int NOT NULL,
	INTERNAL_NAME nvarchar(56) NOT NULL,
	OBJECT_ID bigint NOT NULL,
	ROLEA_INTERNAL_NAME nvarchar(56) NOT NULL,
	ROLEA_OBJECT_ID bigint NOT NULL,
    ROLEB_INTERNAL_NAME nvarchar(56) NOT NULL,
	ROLEB_OBJECT_ID bigint NOT NULL,
    FROM_HISTORY_FLAG bit DEFAULT (0) NULL,
	PRIMARY KEY(SOURCE_CLASS_ID,SOURCE_OBJECT_ID)
)ON [PRIMARY]

Go

CREATE TABLE U_WORKFLOW_META_TEMPLATE_ACTIVITY(
    SOURCE_CLASS_ID int NOT NULL, 
    SOURCE_OBJECT_ID int NOT NULL,
    WORKFLOW_META_TEMPLATE_ID nvarchar(64) NULL,
    WORKFLOW_META_ACTIVITY_ID nvarchar(64) NOT NULL,
    WORKFLOW_META_TEMPLATE_NAME nvarchar(64) NULL,
    WORKFLOW_META_TEMPLATE_FILE_NAME nvarchar(64) NULL,
    WORKFLOW_META_ACTIVITY_NAME nvarchar(64) NULL,
PRIMARY KEY(SOURCE_CLASS_ID,SOURCE_OBJECT_ID,WORKFLOW_META_ACTIVITY_ID)
)ON [PRIMARY]
Go

CREATE INDEX IDX_U_WORKFLOW_META_TEMPLATE_ACTIVITY ON U_WORKFLOW_META_TEMPLATE_ACTIVITY(SOURCE_OBJECT_ID, SOURCE_CLASS_ID)

GO

Go

CREATE TABLE UH_SIGNATURE(
    SOURCE_CLASS_ID int NOT NULL, 
    SOURCE_OBJECT_ID int NOT NULL,
    SOURCE_SNAPSHOT_OBJECT_ID int NOT NULL,
    SOURCE_SNAPSHOT_CLASS_ID int NOT NULL,
    INTERNAL_NAME nvarchar(56) NOT NULL,
    OBJECT_ID bigint NOT NULL,
    WORKFLOW_META_TEMPLATE_ID nvarchar(64) NULL,
    WORKFLOW_META_TEMPLATE_NAME nvarchar(128) NULL,
    WORKFLOW_META_ACTIVITY_ID nvarchar(64) NULL,
    WORKFLOW_META_ACTIVITY_NAME nvarchar(128) NULL,
    SNAPSHOT_OBJECT_ID bigint NOT NULL,
PRIMARY KEY(SOURCE_CLASS_ID,SOURCE_OBJECT_ID,SOURCE_SNAPSHOT_OBJECT_ID,SOURCE_SNAPSHOT_CLASS_ID)
)ON [PRIMARY]



Go

CREATE TABLE UH_DOCUMENTSIGNATURE(
	SOURCE_CLASS_ID int NOT NULL,
	SOURCE_OBJECT_ID int NOT NULL,
    SOURCE_SNAPSHOT_OBJECT_ID int NOT NULL,
    SOURCE_SNAPSHOT_CLASS_ID int NOT NULL,
	SOURCE_ROLEA_CLASS_ID int NOT NULL,
	SOURCE_ROLEA_ID int NOT NULL,
	SOURCE_ROLEB_CLASS_ID int NOT NULL,
	SOURCE_ROLEB_ID int NOT NULL,
	INTERNAL_NAME nvarchar(56) NOT NULL,
	OBJECT_ID bigint NOT NULL,
	ROLEA_INTERNAL_NAME nvarchar(56) NOT NULL,
	ROLEA_OBJECT_ID bigint NOT NULL,
    ROLEB_INTERNAL_NAME nvarchar(56) NOT NULL,
	ROLEB_OBJECT_ID bigint NOT NULL,
    SNAPSHOT_OBJECT_ID bigint NOT NULL,
    PRIMARY KEY(SOURCE_CLASS_ID,SOURCE_OBJECT_ID,SOURCE_SNAPSHOT_OBJECT_ID,SOURCE_SNAPSHOT_CLASS_ID)
)ON [PRIMARY]

GO
CREATE TABLE u_obj_behavior_method_mapping(
    SOURCE_CLASS_ID int NOT NULL, 
    BEHAVIOR_NAME nvarchar(64) NULL,
    METHOD_NAME nvarchar(64) NULL,
    INTERNAL_NAME nvarchar(56) NOT NULL,
    PERMISSION_ITEM_BEHAVIOR_NAME nvarchar(64) NULL,
    PERMISSION_ITEM_METHOD_NAME nvarchar(64) NULL,
    PERMISSION_ITEM_KEY nvarchar(255) NOT NULL,
PRIMARY KEY(SOURCE_CLASS_ID,PERMISSION_ITEM_KEY)
)ON [PRIMARY]

GO
CREATE INDEX IDX_u_obj_behavior_method_mapping ON u_obj_behavior_method_mapping(SOURCE_CLASS_ID, BEHAVIOR_NAME, METHOD_NAME)
Go

CREATE TABLE u_nonactor_classification_mapping(
   NONACTOR_ROLE_INTERNAL_NAME nvarchar(56) NULL,
   NONACTOR_ROLE_OBJECT_ID bigint NOT NULL,
   PERMISSION_CLASSIFICATION nvarchar(255) NOT NULL, 
   PERMISSION_ITEM_KEY nvarchar(255) NULL,
PRIMARY KEY(NONACTOR_ROLE_OBJECT_ID, PERMISSION_CLASSIFICATION)
)ON [PRIMARY]

GO
