# 升级到2025

## 部署升级包
### 2025升级环境清理 
2025部署包里包含了一些升级相关的配置，和正式的升级程序配置冲突,会造成升级数据异常，需要删除
将2025服务端安装目录下的 plm\install\upgrade\supported_version 目录删除。
备注：此目录只会被升级程序使用，不影响2025的功能。

### 升级包部署
将升级包解压缩，将升级包中包含的plm目录拷贝到2025的服务端安装目录下，覆盖2025安装目录下的plm目录。  
备注:升级包中仅包含了升级相关的文件，不影响2025其它文件和功能。   

## 升级前准备

### 支持的版本
目前仅支持2024版本升级到2025，仅支持目前2025包括的模块数据的升级。  
低于2024版本的要升级到2025，需要先升级到2024版本。  
缺省只支持没有定制的标准版升级。  

### 数据库
1.仅支持相同类型的数据库升级。2025对数据库有版本要求，如果当前使用的数据库版本不符合要求，需要部署符合2025要求的数据库版本。  
2.升级时，需要2024版本的plm数据库和2025版本的数据库在一个实例上。如果为2025安装了新的数据库，需要将2024版本的数据库备份并恢复到新安装的数据库上。  

### 文仓
1.主服务对应一个2025的文仓服务。安装时2025的文仓服务的实例名称要和2024主服务的名称一致 (2024缺省是mainserver)。  
2.如果2024部署了多文仓，2025也需要部署多文仓，2024一个文仓服务对应一个2025的文仓服务，安装时2025的文仓服务的实例名称要和2024文仓服务的名称一致。  
3.安装2025文仓服务时，需要指定文仓的存储路径。需要复制一份对应的2024的文仓服务的文仓，将2025的文仓服务路径指向复制的24文仓路径。(这部分相当于升级文仓文件）     
  例如，2024的文仓路径是c:\vault,复制一份到d:\vault2025,安装2025时，需要建立一个虚拟盘，虚拟盘路径指向d:\vault2025    
4.当2024的一个文仓下面有多个路径时(此处指文仓服务配置界面有多个文仓路径)，每个路径对应一个2025的文仓下面的一个虚拟盘。  
  升级前，也可以根据需要合并多个路径，来减少虚拟盘数量。  

### 文档出库状态不升级
文档出库状态不升级，出库的文档升级后，均为非出库状态。
请在升级前，处理好出库文档，将出库文档入库或者取消出库。

### 文档图片签名
2025支持的签名图片格式和2024不同，2025格式主要为png图片，并且有大小限制，存储在数据库中；2024的签名图片格式支持bmp等格式，签名图片存储在文仓中。2024的签名图片无法升级到2025。升级前需要准备好人员对应的png签名图片。升级后，配置人员的签名图片，并勾选 "用此次签名信息修改同步更新库中现有签名信息"。

### 《编码升级工具》
### <font color=red>一、编码升级前的注意事项：</font>
#### 1.补充升级配置文件内容<font color=orange>（如果没有新增编码类型，请忽略）</font>
> 前提：如果除了物料编码，产品编码，文件编码，图号编码，通知单编码之外，还有其它编码类型需要升级，则需要修改升级配置文件，<font color=orange>以24的物料编码为例</font>，方法如下：
```txt
1.添加升级策略配置
(1)路径：install\upgrade\supported_version\2024\codemanagement\upgrade_strategy.json
(2)添加25类名到文件名的映射
        {
            "class_name": "item_code",
            "file_name": [
                {
                    "old_file": "物料编码",
                    "new_file": "item_code"
                }
            ]
        }
(3)说明：
1> class_name: 25编码内部名
2> file_name: xml文件名
3> old_file：24编码的xml文件原始名
4> new_file：升级时转换后的24编码的xml文件名，同时也是升级属性映射的配置名（可自取，但需为英文名）

(4)使用：若还有一个新的24编码需升级到25的物料编码，则只需在对应的file_name里添加一个json对象:
{
    "old_file": "新编码名称",
    "new_file": "xx_code_to_item_code"
}

2.添加属性映射配置
(1)路径：
E:\server\install\upgrade\supported_version\2024\codemanagement\upgrade_strategy\item_code.json

(2)配置说明：
1> item_code.json:属性映射配置名称,需要与 升级策略配置（upgrade_strategy.json）中对应的new_file名 保持一致！
2> from_class: 24类名，通常也是24表名
3> to_class: 25类名
4> class_id: 24classId
5> properties: 属性映射列表
6> from_property：24xml文件中的属性字段
7> to_property：25编码类中的属性内部名（如果24的某个属性不需要被升级，则可以不配置to_property）
8> conversion_method：属性转换方法
9> lookup_map: 如果转换方法为lookup，则需要配置lookup_map

```
### 二、编码升级映射详情

#### 1. 物料编码
- **24classId**: `0`
- **24编码表**: `code2_code`
- **客户端XML文件（原）**: `物料编码.xml`
- **客户端XML文件（转换后）**: `item_code.xml`
- **升级属性映射配置**: `item_code.json`
- **中间表**: `u_item_code`
- **升级到25的编码类型为**: 物料编码

#### 2. 产品编码
- **24classId**: `1`
- **24编码表**: `code2_product_code`
- **客户端XML文件（原）**: `产品编码.xml`
- **客户端XML文件（转换后）**: `product_code.xml`
- **升级属性映射配置**: `product_code.json`
- **中间表**: `u_product_code`
- **升级到25的编码类型为**:产品编码

#### 3. 文件编码
- **24classId**: `2`
- **24编码表**: `code2_code2`
- **客户端XML文件（原）**: `文件编号.xml`
- **客户端XML文件（转换后）**: `file_code_to_generic_code.xml`
- **升级属性映射配置**: `file_code_to_generic_code.json`
- **中间表**: `u_file_code_to_generic_code`
- **升级到25的编码类型为**:<font color=red> 通用编码</font>

#### 4. 图号编码
- **24classId**: `3`
- **24编码表**: `code2_code2`
- **客户端XML文件（原）**: `图号.xml`
- **客户端XML文件（转换后）**: `drawing_code.xml`
- **升级属性映射配置**: `drawing_code.json`
- **升级中间表**: `u_drawing_code`
- **升级到25的编码类型为**:图号编码

#### 5. 通知单编码
- **24classId**: `4`
- **24编码表**: `code2_code2`
- **客户端XML文件（原）**: `通知单号.xml`
- **客户端XML文件（转换后）**: `notice_number_to_generic_code.xml`
- **升级属性映射配置**: `notice_number_to_generic_code.json`
- **中间表**: `u_notice_number_to_generic_code`
- **升级到25的编码类型为**: <font color=red> 通用编码</font>
  
### 三、编码规则升级说明
```txt
升级后的编码规则名称由24classId+upgrade_code_rule组成，例如：24文件编码升级到25通用编码的规则名称为2_upgrade_code_rule。
```
### 2025环境准备
1.升级前，需要部署2025，文仓服务需要按照上面文仓部分进行部署。  
2.升级前请确保2025是空库，没有业务数据，否则会影响升级。  
3.如果因为元模型定制和配置定制，仅建立了用户和角色，没有导入其他业务数据，可以在升级前删除角色和用户。  

### 元模型定制
1.如果元模型有定制，需要先登录2025，定制2025的元模型并映射更新数据库。  
2.如果有相关界面的修改，还需要定制相应的界面配置。  
3.需要手动修改升级配置映射文件，来处理定制的属性升级。  

### 2024配置文件准备
#### 客户端配置文件
将C:\Users\Public\CAXA\CAXA EAP CLIENT\1.0\Cfg目录压缩为zip文件。

#### 服务端配置文件
将服务端部署路径下的Server\Cfg目录压缩为zip文件。

#### 工作流模板
查看工作流服务设置界面，找到模板库配置路径  
将模板库路径下的workflow目录压缩为zip文件。  

### 升级失败的处理
升级过程中，如果数据升级失败，需要人为干预后再继续升级。  
再次升级时，已升级的业务数据可能会影响重新升级的处理。尤其是工作流模板升级错误。  

#### 没有元模型定制的升级失败后处理
如果没有元模型定制，升级失败，处理造成升级失败的原因后，可以删除2025的业务数据库，重新安装2025，再次升级。  

#### 有元模型定制的升级失败后处理
 如果有元模型定制，升级前，需要定制元模型并映射数据库。  
1.映射数据库后，在升级前，备份plm业务数据库，如果升级失败，处理造成升级失败的原因后，使用备份文件恢复plm业务数据库，再次升级。  
   
## 升级

### windows下升级程序位置
[2025安装目录]\plm\bin\caxa_upgrade.exe

### linux下升级程序位置
/opt/CAXA/plm/bin/caxa_upgrade

### 升级到2025
1.运行升级程序，默认会打开浏览器，显示升级界面  
2.输入2024数据库信息  
3.上传配置  
  工作流模板上传后，需要指定模板对应的分类。对不需要分类的模板指定 常规->其他 分类。  
4.勾选要升级的数据项  
5.执行升级  

## 升级后注意事项

### 人员密码
2025默认开启密码安全，对密码有强度要求。密码需要包含大写字母，小写字母，数字，特殊字符（(!, @, #, %, *, &)四类，长度8-16位。
可以使用2025缺省配置来设置用户密码或者在配置系统中修改密码安全配置。
配置入口在配置系统中 系统配置管理-》安全设置-》密码安全

### 人员可用应用
当用户的许可中包含超过一种应用时，升级后，需要在配置系统中设置人员的可用应用。如果不设置，登录业务系统会报错。

### 文档图片签名
2025支持的图片签名格式主要为png图片，且有大小限制。2024如果使用图片签名，升级后，需要配置人员的签名图片，并勾选 "用此次签名信息修改同步更新库中现有签名信息"。

### 权限
2025的权限和2024不是一一对应的。升级后，请检查人员角色的授权，确保权限符合所需。
2025基于工作组管理对象参与者，与2024有较大差异，需要熟悉2025的对象权限管理。
2025设置对象的工作组后，组角色成员在对象上并没有组角色的权限，需要在对象参与者管理页面设置参与者后，根据参与者指定的角色，参与者才会有指定的角色权限。

### 配置
2025和配置和2024的配置格式也不尽相同，升级后，请检查关键配置，比如匹配规则等，以免影响后续新数据入库，其中工艺模板映射和工艺显示配置升级后需重新配置。
如果存在新增的快表工艺类型，需通过配置系统配置“工艺校验配置”。

### 模板文件
2024中的批量导入模板等模板文件如果要继续在2025中使用，需要在2025配置系统的模板文件管理模块中将模板文件导入到对应的分类下。





